/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.container.sync;

import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mekanism.api.annotations.NonNull;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.network.to_client.container.property.FluidStackPropertyData;
import mekanism.common.network.to_client.container.property.IntPropertyData;
import mekanism.common.network.to_client.container.property.PropertyData;
import net.minecraftforge.fluids.FluidStack;

public class SyncableFluidStack
implements ISyncableData {
    @Nonnull
    private FluidStack lastKnownValue = FluidStack.EMPTY;
    private final Supplier<@NonNull FluidStack> getter;
    private final Consumer<@NonNull FluidStack> setter;

    public static SyncableFluidStack create(@Nonnull IExtendedFluidTank handler) {
        return SyncableFluidStack.create(handler, false);
    }

    public static SyncableFluidStack create(IExtendedFluidTank handler, boolean isClient) {
        return SyncableFluidStack.create(() -> ((IExtendedFluidTank)handler).getFluid(), isClient ? handler::setStackUnchecked : handler::setStack);
    }

    public static SyncableFluidStack create(Supplier<@NonNull FluidStack> getter, Consumer<@NonNull FluidStack> setter) {
        return new SyncableFluidStack(getter, setter);
    }

    private SyncableFluidStack(Supplier<@NonNull FluidStack> getter, Consumer<@NonNull FluidStack> setter) {
        this.getter = getter;
        this.setter = setter;
    }

    @Nonnull
    public FluidStack get() {
        return this.getter.get();
    }

    public void set(@Nonnull FluidStack value) {
        this.setter.accept(value);
    }

    public void set(int amount) {
        FluidStack fluid = this.get();
        if (!fluid.isEmpty()) {
            this.set(new FluidStack(fluid.getFluid(), amount));
        }
    }

    @Override
    public ISyncableData.DirtyType isDirty() {
        FluidStack value = this.get();
        boolean sameFluid = value.isFluidEqual(this.lastKnownValue);
        if (!sameFluid || value.getAmount() != this.lastKnownValue.getAmount()) {
            this.lastKnownValue = value.copy();
            return sameFluid ? ISyncableData.DirtyType.SIZE : ISyncableData.DirtyType.DIRTY;
        }
        return ISyncableData.DirtyType.CLEAN;
    }

    @Override
    public PropertyData getPropertyData(short property, ISyncableData.DirtyType dirtyType) {
        if (dirtyType == ISyncableData.DirtyType.SIZE) {
            return new IntPropertyData(property, this.get().getAmount());
        }
        return new FluidStackPropertyData(property, this.get());
    }
}

